//-----------------------------------------------------------------------------
// Microsoft OLE DB RowsetViewer
// Copyright (C) 1994 - 1998 By Microsoft Corporation.
//
// @doc
//
// @module MAIN.H
//
//-----------------------------------------------------------------------------------

#ifndef _MAIN_H_
#define _MAIN_H_


//////////////////////////////////////////////////////////////////////////////
// Includes
//
//////////////////////////////////////////////////////////////////////////////
#include "CDialog.h"
#include "CTable.h"

#include <time.h>			//time_t
#include <sys/timeb.h>		//_timeb
#include "list.h"

						
//////////////////////////////////////////////////////////////////////////////
// Defines
//
//////////////////////////////////////////////////////////////////////////////
enum DIRECTION
{
	FORWARD,
	BACKWARD
};

#define LB_APPEND		LB_ERR
#define LV_ALLITEMS		LVM_ERR
#define LV_ALLSELITEMS	LV_ALLITEMS-1


/////////////////////////////////////////////////////////////////
// Helper Routines
//
/////////////////////////////////////////////////////////////////
CHAR* GetPhaseName(DBEVENTPHASE ePhase);
CHAR* GetReasonName(DBREASON eReason);
CHAR* GetAsynchReason(ULONG ulOperation);
CHAR* GetAsynchPhase(ULONG ulAsynchPhase);
CHAR* GetSchemaName(GUID guidSchema);


/////////////////////////////////////////////////////////////////////
// CMainWindow
//
/////////////////////////////////////////////////////////////////////
class CMainWindow : public CDialogBase
{
public:
	//constructors
	CMainWindow(HWND hWnd, HINSTANCE hInst, HINSTANCE hPrevInst, CHAR* pszCmdLine, INT iCmdShow);
	virtual ~CMainWindow();

	//abstract members
	static LONG WINAPI MainWndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static BOOL WINAPI AboutDlgProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	virtual ULONG Display();
	virtual ULONG Destroy();
	virtual ULONG Run();

	//members
	virtual BOOL InitControls(HWND hWnd);
	virtual BOOL RefreshControls();
	virtual BOOL WantedMenuPos(HMENU hMenu, UINT uPos, DWORD* pdwFlags = NULL);
	virtual	BOOL FullConnect(HWND hWnd);

	//Status Bar
	virtual BOOL DisplayStatusBarItem(UINT uResourceID); 

	//MDI Child Windows
	virtual HWND GetActiveChild();
	virtual CMDIChild* GetActiveChildObj();
	virtual	BOOL RemoveChild(HWND hWnd);
	virtual	BOOL RemoveAllChildren();
	static	ULONG	m_ulChildWindows;

	//Objects
	CConnectDlg* m_pCConnectDlg;
 	COptionsDlg* m_pCOptionsDlg;

	//Controls
	static HWND	m_hWndMDIClient;  	// MDI Client window handle
	HWND		m_hWndToolbar;    	// Toolbar window handle
	HWND		m_hWndStatusbar;  	// status bar handle

	//Data
	HINSTANCE	m_hInstPrev;
	CHAR*		m_pszCmdLine;
	INT			m_iCmdShow;
	BOOL		m_fWarnMaxEditBuffer;

	//Handles
	HCURSOR		m_hCurSizeNS;
	HMODULE		m_hLibRichEdit;

	//list of MTS interfaces
	CList<ITransaction*>	m_listTransactions;
};


/////////////////////////////////////////////////////////////////////
// CMDIChild
//
/////////////////////////////////////////////////////////////////////
class CMDIChild : public CDialogBase
{
public:
	//constructors
	CMDIChild(HWND hWnd, HINSTANCE hInst, CMainWindow* pCMainWindow);
	virtual ~CMDIChild();

	//abstract members
	static LONG WINAPI MDIWinProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	static LONG WINAPI SubClassEditBoxProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static LONG WINAPI SubClassListBoxProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static LONG WINAPI SubClassListViewProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	virtual ULONG Display();

	//members
	virtual BOOL InitControls(HWND hWnd);
	virtual BOOL RefreshControls();
	virtual HRESULT UpdateWndTitle();
	virtual BOOL WantedMenuPos(HMENU hMenu, UINT uPos, DWORD* pdwFlags = NULL);

	//Rowset
	virtual HRESULT CreateRowset(ROWSETSOURCE eRowsetSource, DBID* pTableID = NULL, DBID* pIndexID = NULL, ULONG cPropSets = 0, DBPROPSET* rgPropSets = NULL, REFIID riid = IID_IUnknown, const GUID* pGuidSchema = NULL, ULONG cRestrictions = 0, VARIANT* rgRestrictions = NULL);
	virtual HRESULT DisplayRowset();

	virtual HRESULT DisplayColumnInfo();
	virtual HRESULT DisplayRows(LONG lOffset, LONG cRows);
	virtual HRESULT DisplayData(REFIID riid, HROW hRow, ULONG iIndex);
	virtual HRESULT DumpRow(HROW hRow, ULONG cBindings, DBBINDING* rgBindings, void* pData, ULONG iIndex);

	//IDataset
	virtual HRESULT ExecuteDataset(ROWSETSOURCE eRowsetSource);
	static  BOOL WINAPI AxisInfoProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	static  BOOL WINAPI AxisRowsetProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);

	//ListView
	virtual HRESULT ClearListView(CHAR* pszEmptyName = NULL);
	virtual HRESULT ScrollListView(LONG iRowsToScroll);
	virtual HRESULT SetScroll(LONG lPos);

	virtual HRESULT GetListViewValues(HWND hWndNames, HWND hWndValues, ULONG cBindings, DBBINDING* rgBindings, void* pData);
	virtual HRESULT RefreshData();

	//Session
	virtual HRESULT CreateNewSessionWindow();
	virtual HRESULT CreateNewCommandWindow();

	//IRowset
	virtual HRESULT RestartPosition();
	virtual HRESULT AddRefRows(LONG iIndex);
	virtual HRESULT ReleaseRows(LONG iIndex);
	virtual HRESULT GetNextRows(LONG lOffset, LONG cRows, ULONG* pcRowsObtained = NULL, HROW** prghRows = NULL);
	virtual HRESULT CreateEnumChild();
	
	//IRowset
	virtual HRESULT MoveCursor();
	virtual HRESULT ChangeSelectedRow();
	virtual HRESULT DeleteSelectedRows();
	virtual HRESULT InsertNewRow();
	virtual HRESULT UndoChanges();
	virtual HRESULT UpdateChanges();
	
	//Info Procs
	static BOOL WINAPI GetColInfoProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static BOOL WINAPI GetLiteralInfoProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static BOOL WINAPI ProviderInfoProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	
	//Transaction Procs
 	static BOOL WINAPI StartLocalTxnProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
   	static BOOL WINAPI AbortTransactionProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
   	static BOOL WINAPI CommitTransactionProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
   	static BOOL WINAPI SetTransactionOptionsProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
 	static BOOL WINAPI StartMTSTxnProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
 	static BOOL WINAPI StartJoinTxnProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
 	static BOOL WINAPI GetMTSTxnInfo(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
 	static BOOL WINAPI FreeMTSTxn(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
 	static BOOL WINAPI AbortMTSTransactionProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
 	static BOOL WINAPI CommitMTSTransactionProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);

	//Command Procs
	static BOOL WINAPI CanConvertProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static BOOL WINAPI ParamExecuteProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static BOOL WINAPI SetParameterInfoProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static BOOL WINAPI GetParameterInfoProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static BOOL WINAPI ExecuteProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static BOOL WINAPI SetCommandTextProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);

	//Rowset Procs
	static BOOL WINAPI GetNextRowsProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static BOOL WINAPI GetBindingsProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static BOOL WINAPI RowChangeProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static BOOL WINAPI ColumnChangeProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static BOOL WINAPI OpenRowsetProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static BOOL WINAPI GetColumnsRowsetProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static BOOL WINAPI FindNextRowProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static BOOL WINAPI CreateAccessorProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);

	//IDBDataSourceAdmin Procs
	static BOOL WINAPI AdminCreateDataSourceProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);

	//Enum Procs
	static BOOL WINAPI GetSourcesRowsetProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	
	//IIndexDefinition Procs
	static BOOL WINAPI DropIndexProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);

	//ITableDefinition Procs
	static BOOL WINAPI DropTableProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);

	//General Procs
	static BOOL WINAPI GetInterfaceProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);

	//Helpers
	COptionsDlg*	GetOptionsObj();
	CConnectDlg*	GetConnectObj();

	//Objects
	CMainWindow*	m_pCMainWindow;
	CRowset*		m_pCRowset;
	CError*			m_pCError;
	CPropDlg*		m_pCPropDlg;
	CListBox*		m_pCListBox;

	CSchemaDlg*			m_pCSchemaDlg;
	virtual CSchemaDlg*	const pCSchemaDlg();

	//Data
	HWND	m_hWndListView;
	HWND	m_hWndEditBox;
	HWND	m_hWndScrollBar;

	ULONG	m_iSelectedRow;
	ULONG   m_iSelectedCol;

	//SubClass winproc
	WNDPROC m_pSavedEditBoxProc;
	WNDPROC m_pSavedListBoxProc;
	WNDPROC m_pSavedListViewProc;
	LONG	m_iNotificationIndex;
	
	ULONG   m_ulWindow;
	ULONG   m_ulMaxViewItems;

	//Cursor
	BOOL    m_fPrevFetchForward;
	LONG	m_lCurPos;

	//ScrollBar
	BOOL	m_fEndReached;
	ULONG   m_ulScrollMax;

	//Properties
	ULONG		m_cPropSets;
	DBPROPSET* 	m_rgPropSets;
	
	//Other
	HBITMAP		m_hBitmapReadOnly;

	//Source
	SOURCE		m_eSource;			
	GUID		m_iidSource;
	CHAR*		m_pwszSource;
};


/////////////////////////////////////////////////////////////////
// CListener 
//
/////////////////////////////////////////////////////////////////
class CListener : public IUnknown
{
public:
	CListener(REFIID riid, CListBox* pCListBox);
	virtual ~CListener();
	
	virtual HRESULT Advise(IConnectionPoint* pIConnectionPoint);
	virtual HRESULT Unadvise(IConnectionPoint* pIConnectionPoint);

	virtual HRESULT Advise(IUnknown* pIUnknown);
	virtual HRESULT Unadvise(IUnknown* pIUnknown);

	virtual HRESULT SetReturnValue(HRESULT hrReturn);
	virtual HRESULT GetReturnValue();

	STDMETHODIMP_(ULONG)	AddRef(void);
	STDMETHODIMP_(ULONG)	Release(void);
	STDMETHODIMP QueryInterface(REFIID riid, LPVOID *ppv);

protected:
	//Data
	DWORD		m_dwCookie;		// The cookie that UnAdvise needs
	ULONG		m_cRef;			// reference count
	CListBox*	m_pCListBox;	// Window to dumps to.
	HRESULT		m_hrReturn;

	REFIID		m_riid;
};


/////////////////////////////////////////////////////////////////
// CRowsetNotify 
//
/////////////////////////////////////////////////////////////////
class CRowsetNotify : public IRowsetNotify, public CListener
{
public:
	CRowsetNotify(CListBox* pCListBox);
	virtual ~CRowsetNotify();
	
	STDMETHODIMP_(ULONG)	AddRef(void);
	STDMETHODIMP_(ULONG)	Release(void);
	STDMETHODIMP QueryInterface(REFIID riid, LPVOID *ppv);
	
    virtual HRESULT STDMETHODCALLTYPE OnFieldChange( 
            /* [in] */ IRowset __RPC_FAR *pIRowset,
            /* [in] */ HROW hRow,
            /* [in] */ ULONG cColumns,
            /* [size_is][in] */ ULONG __RPC_FAR rgColumns[  ],
            /* [in] */ DBREASON eReason,
            /* [in] */ DBEVENTPHASE ePhase,
            /* [in] */ BOOL fCantDeny);
        
    virtual HRESULT STDMETHODCALLTYPE OnRowChange( 
            /* [in] */ IRowset __RPC_FAR *pIRowset,
            /* [in] */ ULONG cRows,
            /* [size_is][in] */ const HROW __RPC_FAR rghRows[  ],
            /* [in] */ DBREASON eReason,
            /* [in] */ DBEVENTPHASE ePhase,
            /* [in] */ BOOL fCantDeny);
        
   virtual HRESULT STDMETHODCALLTYPE OnRowsetChange( 
            /* [in] */ IRowset __RPC_FAR *pIRowset,
            /* [in] */ DBREASON eReason,
            /* [in] */ DBEVENTPHASE ePhase,
            /* [in] */ BOOL fCantDeny);

protected:
	//Data
};


/////////////////////////////////////////////////////////////////
// CAsynchNotify 
//
/////////////////////////////////////////////////////////////////
class CAsynchNotify : public IDBAsynchNotify, public CListener
{
public:
	CAsynchNotify(CListBox* pCListBox);
	virtual ~CAsynchNotify();
	
	STDMETHODIMP_(ULONG)	AddRef(void);
	STDMETHODIMP_(ULONG)	Release(void);
	STDMETHODIMP QueryInterface(REFIID riid, LPVOID *ppv);
	
    virtual HRESULT STDMETHODCALLTYPE OnLowResource
		( 
            DWORD dwReserved
		);
        
    virtual HRESULT STDMETHODCALLTYPE OnProgress
		( 
            HCHAPTER hChapter,
            ULONG    ulOperation,
            ULONG    ulProgress,
            ULONG    ulProgressMax,
            ULONG    ulAsynchPhase,
            LPOLESTR pwszStatusText
		);
        
   virtual HRESULT STDMETHODCALLTYPE OnStop
	   ( 
            HCHAPTER hChapter,
            ULONG	 ulOperation,
            HRESULT  hrStatus,
            LPOLESTR pwszStatusText
		);

protected:
	//Data
};


/////////////////////////////////////////////////////////////////
// CRowPosChange 
//
/////////////////////////////////////////////////////////////////
class CRowPosChange : public IRowPositionChange, public CListener
{
public:
	//Contructors
	CRowPosChange(CListBox* pCListBox);
	virtual ~CRowPosChange();

	//methods
	STDMETHODIMP_(ULONG)	AddRef(void);
	STDMETHODIMP_(ULONG)	Release(void);
	STDMETHODIMP QueryInterface(REFIID riid, LPVOID *ppv);

	//interface methods
	STDMETHODIMP_(HRESULT) OnRowPositionChange(
		DBREASON		eReason,
		DBEVENTPHASE	ePhase,
		BOOL			fCantDeny);

protected:
	//data
};


#endif //_MAIN_H_
